<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Video\V1;

use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
class CompositionContext extends InstanceContext {
	/**
	 * Initialize the CompositionContext
	 *
	 * @param \Twilio\Version $version Version that contains the resource
	 * @param string $sid The Composition Sid that uniquely identifies the
	 *                    Composition to fetch.
	 *
	 * @return \Twilio\Rest\Video\V1\CompositionContext
	 */
	public function __construct( Version $version, $sid ) {
		parent::__construct( $version );

		// Path Solution
		$this->solution = array( 'sid' => $sid, );

		$this->uri = '/Compositions/' . rawurlencode( $sid ) . '';
	}

	/**
	 * Fetch a CompositionInstance
	 *
	 * @return CompositionInstance Fetched CompositionInstance
	 * @throws TwilioException When an HTTP error occurs.
	 */
	public function fetch() {
		$params = Values::of( array() );

		$payload = $this->version->fetch(
			'GET',
			$this->uri,
			$params
		);

		return new CompositionInstance( $this->version, $payload, $this->solution['sid'] );
	}

	/**
	 * Deletes the CompositionInstance
	 *
	 * @return boolean True if delete succeeds, false otherwise
	 * @throws TwilioException When an HTTP error occurs.
	 */
	public function delete() {
		return $this->version->delete( 'delete', $this->uri );
	}

	/**
	 * Provide a friendly representation
	 *
	 * @return string Machine friendly representation
	 */
	public function __toString() {
		$context = array();
		foreach ( $this->solution as $key => $value ) {
			$context[] = "$key=$value";
		}

		return '[Twilio.Video.V1.CompositionContext ' . implode( ' ', $context ) . ']';
	}
}